/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import org.noear.solon.boot.undertow.websocket.UtWsChannelListener;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.xnio.ChannelListener;

public class UtWsConnectionCallback
implements WebSocketConnectionCallback {
    private final UtWsChannelListener listener = new UtWsChannelListener();
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onHandshake(WebSocketHttpExchange exchange) {
        String path = URI.create(exchange.getRequestURI()).getPath();
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", subProtocolCapable.getSubProtocols());
        }
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        this.listener.onOpen(exchange, channel);
        channel.getReceiveSetter().set((ChannelListener)this.listener);
        channel.resumeReceives();
    }
}

