/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket.WebSocketImpl;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Pooled;

public class UtWsChannelListener
extends AbstractReceiveListener {
    static final Logger log = LoggerFactory.getLogger(UtWsChannelListener.class);
    private final String SESSION_KEY = "session";
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void handleEvent(WebSocketChannel channel) {
        boolean receiveThrowable;
        StreamSourceFrameChannel result;
        block15: {
            result = null;
            receiveThrowable = false;
            try {
                result = (StreamSourceFrameChannel)channel.receive();
            }
            catch (Throwable e) {
                receiveThrowable = true;
                if (e instanceof SocketException) break block15;
                this.onError(channel, e);
            }
        }
        try {
            if (result == null) {
                if (!channel.isOpen() || receiveThrowable) {
                    this.onClose(channel, result);
                }
                return;
            }
            if (result.getType() == WebSocketFrameType.BINARY) {
                this.onBinary(channel, result);
            } else if (result.getType() == WebSocketFrameType.TEXT) {
                this.onText(channel, result);
            } else if (result.getType() == WebSocketFrameType.PONG) {
                this.onPong(channel, result);
            } else if (result.getType() == WebSocketFrameType.PING) {
                this.onPing(channel, result);
            } else if (result.getType() == WebSocketFrameType.CLOSE) {
                this.onClose(channel, result);
            }
        }
        catch (IOException e) {
            this.onError(channel, e);
        }
    }

    public void onOpen(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        WebSocketImpl webSocket = new WebSocketImpl(channel);
        exchange.getRequestHeaders().forEach((k, v) -> {
            if (v.size() > 0) {
                webSocket.param((String)k, (String)v.get(0));
            }
        });
        channel.setAttribute("session", (Object)webSocket);
        this.webSocketRouter.getListener().onOpen((WebSocket)webSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage msg) throws IOException {
        try {
            Pooled pulledData = msg.getData();
            try {
                ByteBuffer[] resource = (ByteBuffer[])pulledData.getResource();
                ByteBuffer byteBuffer = WebSockets.mergeBuffers((ByteBuffer[])resource);
                WebSocketImpl webSocket = (WebSocketImpl)((Object)channel.getAttribute("session"));
                this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, byteBuffer);
            }
            finally {
                pulledData.discard();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage msg) throws IOException {
        try {
            WebSocketImpl webSocket = (WebSocketImpl)((Object)channel.getAttribute("session"));
            this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, msg.getData());
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        WebSocketImpl webSocket = (WebSocketImpl)((Object)channel.getAttribute("session"));
        if (webSocket.isClosed()) {
            return;
        }
        RunUtil.runAndTry(webSocket::close);
        this.webSocketRouter.getListener().onClose((WebSocket)webSocket);
    }

    protected void onPing(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
        super.onPing(webSocketChannel, channel);
        WebSocketImpl webSocket = (WebSocketImpl)((Object)webSocketChannel.getAttribute("session"));
        this.webSocketRouter.getListener().onPing((WebSocket)webSocket);
    }

    protected void onPong(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        super.onPong(webSocketChannel, messageChannel);
        WebSocketImpl webSocket = (WebSocketImpl)((Object)webSocketChannel.getAttribute("session"));
        this.webSocketRouter.getListener().onPong((WebSocket)webSocket);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        try {
            WebSocketImpl webSocket = (WebSocketImpl)((Object)channel.getAttribute("session"));
            this.webSocketRouter.getListener().onError((WebSocket)webSocket, error);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

