/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.undertow.UndertowServer;
import org.noear.solon.boot.undertow.UndertowServerAddJsp;
import org.noear.solon.boot.undertow.UndertowServerBase;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private UndertowServerBase _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "undertow 2.2.24/" + Solon.version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        context.lifecycle(-99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        Class jspClz = ClassUtil.loadClass((String)"io.undertow.jsp.JspServletBuilder");
        this._server = jspClz == null ? new UndertowServer() : new UndertowServerAddJsp();
        HttpServerProps props = this._server.getProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        EventBus.push((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: undertow: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        System.out.println(connectorInfo + "}{http://localhost:" + _port + "}");
        LogUtil.global().info("Server:main: undertow: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: undertow: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

