/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.websockets.WebSocketConnectionCallback;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.undertow.PluginUndertowBase;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.boot.undertow.http.UtHandlerJspHandler;
import org.noear.solon.boot.undertow.websocket.UtWsConnectionCallback;
import org.noear.solon.boot.undertow.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.socketd.SessionManager;

class PluginUndertow
extends PluginUndertowBase
implements Plugin {
    Undertow _server;
    int port;

    public PluginUndertow(int port) {
        this.port = port;
    }

    public void start(SolonApp app) {
        try {
            this.setup(app);
            this._server.start();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app) throws Throwable {
        HttpHandler httpHandler = this.buildHandler();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)XServerProp.request_maxRequestSize);
        builder.addHttpListener(this.port, "0.0.0.0");
        if (app.enableWebSocket()) {
            builder.setHandler((HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new UtWsConnectionCallback(), (HttpHandler)httpHandler));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            builder.setHandler(httpHandler);
        }
        EventBus.push((Object)builder);
        this._server = builder.build();
    }

    protected HttpHandler buildHandler() throws Exception {
        DeploymentInfo builder = this.initDeploymentInfo();
        builder.addServlet(new ServletInfo("ACTServlet", UtHandlerJspHandler.class).addMapping("/"));
        ServletContainer container = Servlets.defaultContainer();
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        return manager.start();
    }
}

