/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.http;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.Solon;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.core.handle.Context;
import org.noear.solon.extend.servlet.SolonServletContext;

public class UtHttpHandler
implements HttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        try {
            this.service(request, response);
        }
        finally {
            exchange.endExchange();
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SolonServletContext context = new SolonServletContext(request, response);
        context.contentType("text/plain;charset=UTF-8");
        if (XServerProp.output_meta) {
            context.headerSet("solon.boot", XPluginImp.solon_boot_ver());
        }
        Solon.global().tryHandle((Context)context);
        if (!context.getHandled() || context.status() == 404) {
            response.setStatus(404);
        }
    }
}

