/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.undertow.PluginUndertow;
import org.noear.solon.boot.undertow.PluginUndertowJsp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;

public final class XPluginImp
implements Plugin {
    private Plugin _server = null;

    public static String solon_boot_ver() {
        return "undertow 2.1/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        Aop.context().beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        XServerProp.init();
        Aop.beanOnloaded(() -> this.start0(app));
    }

    private void start0(SolonApp app) {
        long time_start = System.currentTimeMillis();
        System.out.println("solon.Server:main: Undertow 2.1.09(undertow)");
        Class jspClz = Utils.loadClass((String)"io.undertow.jsp.JspServletBuilder");
        this._server = jspClz == null ? new PluginUndertow() : new PluginUndertowJsp();
        this._server.start(app);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.Connector:main: undertow: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + app.port() + "}");
        } else {
            System.out.println(connectorInfo + "}{0.0.0.0:" + app.port() + "}");
        }
        System.out.println("solon.Server:main: undertow: Started @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            System.out.println("solon.Server:main: undertow: Has Stopped " + XPluginImp.solon_boot_ver());
        }
    }
}

