/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;

public class UtWsChannelListener
extends AbstractReceiveListener {
    public void onOpen(WebSocketChannel channel) {
        XListenerProxy.getGlobal().onOpen(_SocketSession.get(channel));
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage msg) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (ByteBuffer buf : (ByteBuffer[])msg.getData().getResource()) {
                out.write(buf.array());
            }
            XSession session = _SocketSession.get(channel);
            XMessage message = XMessage.wrap((String)channel.getUrl(), (byte[])out.toByteArray());
            XListenerProxy.getGlobal().onMessage(session, message, false);
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage msg) throws IOException {
        try {
            XSession session = _SocketSession.get(channel);
            XMessage message = XMessage.wrap((String)channel.getUrl(), (byte[])msg.getData().getBytes("UTF-8"));
            XListenerProxy.getGlobal().onMessage(session, message, true);
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        XListenerProxy.getGlobal().onClose(_SocketSession.get(channel));
        _SocketSession.remove(channel);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        XListenerProxy.getGlobal().onError(_SocketSession.get(channel), error);
    }
}

