/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.jsp.HackInstanceManager;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.DefaultClassIntrospector;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.MultipartConfigElement;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.tomcat.InstanceManager;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.boot.undertow.UtHttpHandlerJsp;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.boot.undertow.jsp.JspResourceManager;
import org.noear.solon.boot.undertow.jsp.JspTldLocator;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XPlugin;

public class XPluginUndertowJsp
implements XPlugin {
    private static Undertow.Builder serverBuilder = null;
    private static Undertow _server = null;

    public void start(XApp app) {
        try {
            this.setupJsp(app);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _server.start();
    }

    public void setupJsp(XApp app) throws Exception {
        ServletContainer container = ServletContainer.Factory.newInstance();
        MultipartConfigElement configElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        String fileRoot = this.getResourceRoot();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(XPluginUndertowJsp.class.getClassLoader()).setDeploymentName("solon").setContextPath("/").setDefaultEncoding(XServerProp.encoding_request).setDefaultMultipartConfig(configElement).setClassIntrospecter((ClassIntrospecter)DefaultClassIntrospector.INSTANCE);
        builder.setResourceManager((ResourceManager)new JspResourceManager((ClassLoader)XClassLoader.global(), fileRoot)).addServlet(JspServletBuilder.createServlet((String)"JSPServlet", (String)"*.jsp")).addServlet(new ServletInfo("ACTServlet", UtHttpHandlerJsp.class).addMapping("/"));
        if (XServerProp.session_timeout > 0) {
            builder.setDefaultSessionTimeout(XServerProp.session_timeout);
        }
        HashMap<String, TagLibraryInfo> tagLibraryMap = JspTldLocator.createTldInfos("WEB-INF");
        JspServletBuilder.setupDeployment((DeploymentInfo)builder, new HashMap(), tagLibraryMap, (InstanceManager)new HackInstanceManager());
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        HttpHandler jsp_handler = manager.start();
        serverBuilder = XPluginUndertowJsp.getInstance().setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        serverBuilder.addHttpListener(app.port(), "0.0.0.0");
        serverBuilder.setHandler(jsp_handler);
        _server = serverBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Undertow.Builder getInstance() {
        Class<XPluginImp> clazz = XPluginImp.class;
        synchronized (XPluginImp.class) {
            if (serverBuilder != null) return serverBuilder;
            Class<XPlugin> clazz2 = XPlugin.class;
            synchronized (XPlugin.class) {
                serverBuilder = Undertow.builder();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return serverBuilder;
            }
        }
    }

    public void stop() throws Throwable {
        if (_server != null) {
            _server.stop();
            _server = null;
        }
    }

    private String getResourceRoot() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean isDebug = XApp.cfg().isDebugMode();
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            return resURL.substring(0, endIndex) + "src/main/resources/";
        }
        return "";
    }

    private URL getRootPath() {
        URL root = XUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = XUtil.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

