/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import org.noear.solon.XApp;
import org.noear.solon.boot.undertow.UtHttpExchangeHandler;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.core.XPlugin;

public class XPluginUndertow
implements XPlugin {
    private static Undertow.Builder serverBuilder = null;
    private Undertow _server = null;

    public void start(XApp app) {
        Undertow.Builder builder = XPluginUndertow.getInstance();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        UtHttpExchangeHandler _handler = new UtHttpExchangeHandler(app);
        DeploymentManager manager = this.doGenerateManager(_handler, app);
        HttpHandler f_handler = null;
        try {
            f_handler = manager.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        builder.addHttpListener(app.port(), "0.0.0.0");
        builder.setHandler(f_handler);
        this._server = builder.build();
        try {
            this._server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DeploymentManager doGenerateManager(UtHttpExchangeHandler innerHandler, XApp app) {
        HandlerWrapper wrapper = nothing -> innerHandler;
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(XPluginImp.class.getClassLoader()).setDeploymentName("YK").setContextPath("/").setDefaultMultipartConfig(multipartConfigElement).addInnerHandlerChainWrapper(wrapper);
        if (XServerProp.session_timeout > 0) {
            builder.setDefaultSessionTimeout(XServerProp.session_timeout);
        }
        ServletContainer _container = Servlets.defaultContainer();
        DeploymentManager deploymentManager = _container.addDeployment(builder);
        deploymentManager.deploy();
        return deploymentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Undertow.Builder getInstance() {
        Class<XPluginImp> clazz = XPluginImp.class;
        synchronized (XPluginImp.class) {
            if (serverBuilder != null) return serverBuilder;
            Class<XPlugin> clazz2 = XPlugin.class;
            synchronized (XPlugin.class) {
                serverBuilder = Undertow.builder();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return serverBuilder;
            }
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }
}

