/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.http;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.XApp;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.http.UtHttpContext;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XEventBus;

public class UtHttpHandler
implements HttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        UtHttpContext context = new UtHttpContext(request, response);
        context.contentType("text/plain;charset=UTF-8");
        context.headerSet("solon.boot", XPluginImp.solon_boot_ver());
        try {
            if (exchange.getRequestURI() != null && !exchange.getRequestURI().endsWith(".jsp")) {
                XApp.global().tryHandle((XContext)context);
            }
            if (!context.getHandled() || context.status() == 404) {
                exchange.setStatusCode(404);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
            exchange.setStatusCode(500);
            if (XApp.cfg().isDebugMode()) {
                ex.printStackTrace(response.getWriter());
            }
        }
        finally {
            exchange.endExchange();
        }
    }
}

