/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.context;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.XUtil;
import org.noear.solon.boot.undertow.ext.MultipartUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XSessionState;

public class UtHttpExchangeContext
extends XContext {
    private ServletRequest _request;
    private ServletResponse _response;
    private HttpServerExchange _exchange;
    private URI _uri;
    private XMap _paramMap;
    private XMap _cookieMap;
    private XMap _headerMap;

    public UtHttpExchangeContext(ServletRequest request, ServletResponse response, HttpServerExchange exchange) {
        this._request = request;
        this._response = response;
        this._exchange = exchange;
        if (this.sessionState().replaceable()) {
            this.sessionStateInit(new XSessionState(){

                public String sessionId() {
                    SessionManager sm = (SessionManager)UtHttpExchangeContext.this._exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                    SessionConfig sc = (SessionConfig)UtHttpExchangeContext.this._exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
                    return sm.getSession(UtHttpExchangeContext.this._exchange, sc).getId();
                }

                public Object sessionGet(String key) {
                    SessionConfig sc = (SessionConfig)UtHttpExchangeContext.this._exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
                    return ((SessionManager)UtHttpExchangeContext.this._exchange.getAttachment(SessionManager.ATTACHMENT_KEY)).getSession(UtHttpExchangeContext.this._exchange, sc).getAttribute(key);
                }

                public void sessionSet(String key, Object val) {
                    SessionConfig sc = (SessionConfig)UtHttpExchangeContext.this._exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
                    ((SessionManager)UtHttpExchangeContext.this._exchange.getAttachment(SessionManager.ATTACHMENT_KEY)).getSession(UtHttpExchangeContext.this._exchange, sc).setAttribute(key, val);
                }
            });
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getRemoteAddr();
        }
        return "";
    }

    public String method() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getMethod();
        }
        return this._exchange.getRequestMethod().toString();
    }

    public String protocol() {
        if (this._request instanceof HttpServletRequest) {
            return this._request.getProtocol();
        }
        return this._exchange.getProtocol().toString();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getRequestURI();
        }
        return this._exchange.getRequestURI();
    }

    public String url() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getRequestURL().toString();
        }
        return this._exchange.getRequestURL();
    }

    public long contentLength() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getContentLength();
        }
        return this._exchange.getRequestContentLength();
    }

    public String contentType() {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getContentType();
        }
        HeaderMap headers = this._exchange.getRequestHeaders();
        String content_type = headers.getFirst("Content-Type");
        if (content_type == null) {
            return "";
        }
        return content_type;
    }

    public String body() throws IOException {
        InputStream inpStream = this.bodyAsStream();
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens = -1;
        while ((lens = inpStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public String[] paramValues(String key) {
        return this._request.getParameterValues(key);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public String param(String key, String def) {
        String temp = (String)this.paramMap().get((Object)key);
        if (XUtil.isEmpty((String)temp)) {
            return def;
        }
        return temp;
    }

    public XMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new XMap();
            Enumeration names = this._request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = this._request.getParameter(name);
                this._paramMap.put(name, (Object)value);
            }
        }
        return this._paramMap;
    }

    public Map<String, String[]> paramsMap() {
        return this._request.getParameterMap();
    }

    public void paramSet(String key, String val) {
        this.paramMap().put(key, (Object)val);
    }

    public List<XFile> files(String key) throws Exception {
        if (this.isMultipartFormData()) {
            return MultipartUtil.getUploadedFiles(this, key);
        }
        return new ArrayList<XFile>();
    }

    public String cookie(String key) {
        return this.cookie(key, null);
    }

    public String cookie(String key, String def) {
        String temp = (String)this.cookieMap().get((Object)key);
        if (temp == null) {
            return def;
        }
        return temp;
    }

    public XMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new XMap();
            javax.servlet.http.Cookie[] _cookies = null;
            if (this._request instanceof HttpServletRequest) {
                _cookies = ((HttpServletRequest)this._request).getCookies();
                if (_cookies != null) {
                    for (javax.servlet.http.Cookie c : _cookies) {
                        this._cookieMap.put(c.getName(), (Object)c.getValue());
                    }
                }
            } else {
                Map cookieMap = this._exchange.getRequestCookies();
                cookieMap.forEach((s, cookie) -> this._cookieMap.put(cookie.getName(), (Object)cookie.getValue()));
            }
        }
        return this._cookieMap;
    }

    public String header(String key) {
        if (this._request instanceof HttpServletRequest) {
            return ((HttpServletRequest)this._request).getHeader(key);
        }
        HeaderMap headers = this._exchange.getRequestHeaders();
        return headers.getFirst(key);
    }

    public String header(String key, String def) {
        String temp = this.header(key);
        if (XUtil.isEmpty((String)temp)) {
            return def;
        }
        return temp;
    }

    public XMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new XMap();
            HeaderMap headers = this._exchange.getRequestHeaders();
            headers.forEach(hv -> this.headerMap().put(hv.getHeaderName().toString(), (Object)hv.getFirst()));
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
    }

    protected void contentTypeDoSet(String contentType) {
        this._response.setContentType(contentType);
    }

    public OutputStream outputStream() throws IOException {
        return this._exchange.getOutputStream();
    }

    public void output(String str) {
        PrintWriter writer = new PrintWriter(this._exchange.getOutputStream());
        writer.write(str);
        writer.flush();
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this._exchange.getOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                out.write(buff, 0, rc);
            }
            out.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        if (this._response instanceof HttpServletResponse) {
            ((HttpServletResponse)this._response).setHeader(key, val);
        }
        HeaderMap respHeaders = this._exchange.getResponseHeaders();
        respHeaders.add(new HttpString(key), val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        CookieImpl c = new CookieImpl(key, val);
        if (XUtil.isNotEmpty((String)path)) {
            c.setPath(path);
        }
        c.setMaxAge(Integer.valueOf(maxAge));
        if (XUtil.isNotEmpty((String)domain)) {
            c.setDomain(domain);
        }
        this._exchange.setResponseCookie((Cookie)c);
    }

    public void redirect(String url) {
        if (this._response instanceof HttpServletResponse) {
            try {
                ((HttpServletResponse)this._response).sendRedirect(url);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void redirect(String url, int code) {
        this.status(code);
        if (this._response instanceof HttpServletResponse) {
            ((HttpServletResponse)this._response).setHeader("Location", url);
        }
    }

    public int status() {
        return this._exchange.getStatusCode();
    }

    public void status(int status) {
        this._exchange.setStatusCode(status);
    }
}

