/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.smarthttp.http.SmHttpContextHandler;
import org.noear.solon.boot.smarthttp.websocket.SmWebSocketHandleImpl;
import org.noear.solon.boot.ssl.SslConfig;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;

public class SmHttpServer
implements ServerLifecycle {
    protected HttpServerProps props = HttpServerProps.getInstance();
    private HttpBootstrap server = null;
    private Handler handler;
    private int coreThreads;
    private Executor workExecutor;
    private boolean enableWebSocket;
    private SslConfig sslConfig = new SslConfig("http");
    private boolean enableDebug = false;
    private boolean isSecure;

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public void enableDebug(boolean enable) {
        this.enableDebug = enable;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setWorkExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public void start(String host, int port) throws Throwable {
        this.server = new HttpBootstrap();
        HttpServerConfiguration _config = this.server.configuration();
        if (Utils.isNotEmpty((String)host)) {
            _config.host(host);
        }
        if (this.sslConfig.isSslEnable()) {
            SSLContext sslContext = this.sslConfig.getSslContext();
            SslPlugin sslPlugin = new SslPlugin(() -> sslContext, sslEngine -> sslEngine.setUseClientMode(false));
            _config.addPlugin((Plugin)sslPlugin);
            this.isSecure = true;
        }
        _config.debug(this.enableDebug);
        _config.bannerEnabled(false);
        _config.readBufferSize(8192);
        _config.threadNum(this.coreThreads);
        _config.setHttpIdleTimeout((int)this.props.getIdleTimeoutOrDefault());
        if (ServerProps.request_maxHeaderSize > 0) {
            _config.readBufferSize(ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize > 0L) {
            if (ServerProps.request_maxBodySize > Integer.MAX_VALUE) {
                _config.setMaxRequestSize(Integer.MAX_VALUE);
            } else {
                _config.setMaxRequestSize((int)ServerProps.request_maxBodySize);
            }
        }
        EventBus.publish((Object)_config);
        SmHttpContextHandler handlerTmp = new SmHttpContextHandler(this.handler);
        handlerTmp.setExecutor(this.workExecutor);
        this.server.httpHandler((HttpServerHandler)handlerTmp);
        if (this.enableWebSocket) {
            this.server.webSocketHandler((WebSocketHandler)new SmWebSocketHandleImpl());
        }
        this.server.setPort(port);
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

