/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.WebSocketBase;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class WebSocketImpl
extends WebSocketBase {
    private final WebSocketRequest request;
    private final WebSocketResponse real;

    public WebSocketImpl(WebSocketRequest request) {
        this.request = request;
        this.real = ((WebSocketRequestImpl)request).getResponse();
        this.init(this.buildUri(request));
    }

    public URI buildUri(WebSocketRequest req) {
        if (Utils.isEmpty((String)req.getQueryString())) {
            return URI.create(req.getRequestURL());
        }
        if (req.getRequestURL().contains("?")) {
            return URI.create(req.getRequestURL());
        }
        return URI.create(req.getRequestURL() + "?" + req.getQueryString());
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.request.getRemoteAddress();
    }

    public InetSocketAddress localAddress() {
        return this.request.getLocalAddress();
    }

    public void send(String text) {
        this.real.sendTextMessage(text);
    }

    public void send(ByteBuffer binary) {
        this.real.sendBinaryMessage(binary.array());
    }

    public void close() {
        super.close();
        this.real.close();
    }
}

