/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.http.HttpServerConfigure;
import org.noear.solon.boot.smarthttp.SmHttpServer;
import org.noear.solon.core.handle.Handler;

public class SmHttpServerComb
implements HttpServerConfigure,
ServerLifecycle {
    private int coreThreads;
    private Executor workExecutor;
    private boolean enableWebSocket;
    private Handler handler;
    protected boolean enableSsl = true;
    protected boolean enableDebug = false;
    protected Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    protected List<SmHttpServer> servers = new ArrayList<SmHttpServer>();

    public void enableSsl(boolean enable) {
        this.enableSsl = enable;
    }

    public void enableDebug(boolean enable) {
        this.enableDebug = enable;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public void setExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public boolean isSecure() {
        if (this.servers.size() > 0) {
            return this.servers.get(0).isSecure();
        }
        return false;
    }

    public void start(String host, int port) throws Throwable {
        SmHttpServer s1 = new SmHttpServer();
        s1.setWorkExecutor(this.workExecutor);
        s1.setCoreThreads(this.coreThreads);
        s1.enableWebSocket(this.enableWebSocket);
        s1.setHandler(this.handler);
        s1.enableSsl(this.enableSsl);
        s1.enableDebug(this.enableDebug);
        s1.start(host, port);
        this.servers.add(s1);
        for (Integer portAdd : this.addHttpPorts) {
            SmHttpServer s2 = new SmHttpServer();
            s2.setWorkExecutor(this.workExecutor);
            s2.setCoreThreads(this.coreThreads);
            s2.enableWebSocket(this.enableWebSocket);
            s2.setHandler(this.handler);
            s2.enableSsl(false);
            s2.enableDebug(this.enableDebug);
            s2.start(host, portAdd);
            this.servers.add(s2);
        }
    }

    public void stop() throws Throwable {
        for (ServerLifecycle serverLifecycle : this.servers) {
            serverLifecycle.stop();
        }
    }
}

