/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode.websocket;

import java.nio.ByteBuffer;
import org.smartboot.http.server.decode.websocket.Decoder;
import org.smartboot.http.server.decode.websocket.PayloadLengthDecoder;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class BasicFrameDecoder
implements Decoder {
    private final Decoder payloadLengthDecoder = new PayloadLengthDecoder();

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocketRequestImpl request) {
        if (byteBuffer.remaining() < 2) {
            return this;
        }
        byte first = byteBuffer.get();
        byte second = byteBuffer.get();
        boolean mask = (second & 0x80) != 0;
        boolean fin = (first & 0x80) != 0;
        int rsv = (first & 0x70) >> 4;
        int opcode = first & 0xF;
        request.setFrameFinalFlag(fin);
        request.setFrameRsv(rsv);
        request.setFrameOpcode(opcode);
        request.setFrameMasked(mask);
        request.setPayloadLength(second & 0x7F);
        return this.payloadLengthDecoder.decode(byteBuffer, request);
    }
}

