/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpProtocolDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.transport.AioSession;

class HttpUriQueryDecoder
extends AbstractDecoder {
    private final HttpProtocolDecoder decoder = new HttpProtocolDecoder(this.getConfiguration());

    public HttpUriQueryDecoder(HttpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, AioSession aioSession, Request request) {
        int length = this.scanUriQuery(byteBuffer);
        if (length >= 0) {
            String query = StringUtils.convertToString((ByteBuffer)byteBuffer, (int)(byteBuffer.position() - 1 - length), (int)length);
            request.setQueryString(query);
            return this.decoder.decode(byteBuffer, aioSession, request);
        }
        return this;
    }

    private int scanUriQuery(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return -1;
        }
        int i = 0;
        buffer.mark();
        while (buffer.hasRemaining()) {
            if (buffer.get() == 32) {
                return i;
            }
            ++i;
        }
        buffer.reset();
        return -1;
    }
}

