/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.io.InputStream;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.io.ChunkedInputStream;
import org.smartboot.http.common.io.PostInputStream;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.HttpResponseImpl;
import org.smartboot.http.server.impl.Request;

public class HttpRequestImpl
extends AbstractRequest {
    private boolean keepAlive;
    protected static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private final HttpResponseImpl response;
    private InputStream inputStream;

    HttpRequestImpl(Request request) {
        this.init(request);
        this.response = new HttpResponseImpl(this, request);
    }

    @Override
    public final HttpResponseImpl getResponse() {
        return this.response;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        int contentLength;
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = HeaderValueEnum.CHUNKED.getName().equalsIgnoreCase(this.request.getHeader(HeaderNameEnum.TRANSFER_ENCODING.getName())) ? new ChunkedInputStream(this.request.getAioSession()) : ((contentLength = this.getContentLength()) > 0 && this.request.getFormUrlencoded() == null ? new PostInputStream(this.request.getAioSession().getInputStream(contentLength), contentLength) : EMPTY_INPUT_STREAM);
        return this.inputStream;
    }

    public void reset() {
        this.request.reset();
        this.response.reset();
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inputStream = null;
        }
    }
}

