/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode.websocket;

import java.nio.ByteBuffer;
import org.smartboot.http.server.decode.websocket.Decoder;
import org.smartboot.http.server.decode.websocket.PayloadDecoder;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

class MaskingKeyDecoder
implements Decoder {
    private final Decoder payloadDecoder = new PayloadDecoder();

    MaskingKeyDecoder() {
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocketRequestImpl request) {
        if (request.isFrameMasked()) {
            if (byteBuffer.remaining() < 4) {
                return this;
            }
            byte[] maskingKey = new byte[4];
            byteBuffer.get(maskingKey);
            request.setMaskingKey(maskingKey);
        }
        return this.payloadDecoder.decode(byteBuffer, request);
    }
}

