/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpHeaderDecoder;
import org.smartboot.http.server.decode.LfDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.transport.AioSession;

class HttpProtocolDecoder
extends AbstractDecoder {
    private final HttpHeaderDecoder decoder = new HttpHeaderDecoder(this.getConfiguration());
    private final LfDecoder lfDecoder = new LfDecoder(this.decoder, this.getConfiguration());

    public HttpProtocolDecoder(HttpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, AioSession aioSession, Request request) {
        ByteTree protocol = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)CR_END_MATCHER, this.getConfiguration().getByteCache());
        if (protocol != null) {
            request.setProtocol(protocol.getStringValue());
            return this.lfDecoder.decode(byteBuffer, aioSession, request);
        }
        return this;
    }
}

