/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.smarthttp.SmHttpServer;
import org.noear.solon.boot.smarthttp.http.FormContentFilter;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private SmHttpServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "smart http 1.1/" + Solon.version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        context.lifecycle(-99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        this._server = new SmHttpServer();
        this._server.setEnableWebSocket(app.enableWebSocket());
        this._server.setCoreThreads(props.getCoreThreads());
        if (props.isIoBound()) {
            this._server.setWorkExecutor(props.getBioExecutor("smarthttp-"));
        }
        this._server.setHandler(arg_0 -> ((SolonApp)Solon.app()).tryHandle(arg_0));
        this._server.start(_host, _port);
        EventBus.push((Object)this._server);
        app.signalAdd(_signal);
        app.before(-9, (Handler)new FormContentFilter());
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            LogUtil.global().info(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        LogUtil.global().info(connectorInfo + "}{http://localhost:" + _port + "}");
        LogUtil.global().info("Server:main: smarthttp: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: smarthttp: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

