/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http.uploadfile;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultipartInputStream
extends FilterInputStream {
    protected final byte[] boundary;
    protected final byte[] buf = new byte[4096];
    protected int head;
    protected int tail;
    protected int end;
    protected int len;
    protected int state;

    protected MultipartInputStream(InputStream in, byte[] boundary) {
        super(in);
        int len = boundary.length;
        if (len == 0 || len > 70) {
            throw new IllegalArgumentException("invalid boundary length");
        }
        this.boundary = new byte[len + 4];
        System.arraycopy("\r\n", 0, this.boundary, 0, 2);
        this.boundary[3] = 45;
        this.boundary[2] = 45;
        System.arraycopy(boundary, 0, this.boundary, 4, len);
    }

    @Override
    public int read() throws IOException {
        if (!this.fill()) {
            return -1;
        }
        return this.buf[this.head++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.fill()) {
            return -1;
        }
        len = Math.min(this.tail - this.head, len);
        System.arraycopy(this.buf, this.head, b, off, len);
        this.head += len;
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        if (len <= 0L || !this.fill()) {
            return 0L;
        }
        len = Math.min((long)(this.tail - this.head), len);
        this.head = (int)((long)this.head + len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.tail - this.head;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean nextPart() throws IOException {
        while (this.skip(this.buf.length) != 0L) {
        }
        this.head = this.tail += this.len;
        this.state |= 1;
        if (this.state >= 8) {
            this.state |= 0x10;
            return false;
        }
        this.findBoundary();
        return true;
    }

    protected boolean fill() throws IOException {
        int read;
        if (this.head != this.tail) {
            return true;
        }
        if (this.tail > this.buf.length - 256) {
            System.arraycopy(this.buf, this.tail, this.buf, 0, this.end -= this.tail);
            this.tail = 0;
            this.head = 0;
        }
        do {
            if ((read = super.read(this.buf, this.end, this.buf.length - this.end)) < 0) {
                this.state |= 4;
            } else {
                this.end += read;
            }
            this.findBoundary();
        } while (read > 0 && this.tail == this.head && this.len == 0);
        if (this.tail != 0) {
            this.state |= 1;
        }
        if (this.state < 8 && this.len > 0) {
            this.state |= 2;
        }
        if ((this.state & 6) == 4 || this.len == 0 && ((this.state & 0xFC) == 4 || read == 0 && this.tail == this.head)) {
            throw new IOException("missing boundary");
        }
        if (this.state >= 16) {
            this.tail = this.end;
        }
        return this.tail > this.head;
    }

    protected void findBoundary() throws IOException {
        this.len = 0;
        int off = this.tail - ((this.state & 1) != 0 || this.buf[0] != 45 ? 0 : 2);
        int end = this.end;
        while (this.tail < end) {
            int j;
            for (j = this.tail; j < end && j - off < this.boundary.length && this.buf[j] == this.boundary[j - off]; ++j) {
            }
            if (j + 1 >= end) {
                return;
            }
            if (j - off == this.boundary.length) {
                if (this.buf[j] == 45 && this.buf[j + 1] == 45) {
                    j += 2;
                    this.state |= 8;
                }
                while (j < end && (this.buf[j] == 32 || this.buf[j] == 9)) {
                    ++j;
                }
                if (j + 1 < end && this.buf[j] == 13 && this.buf[j + 1] == 10) {
                    this.len = j - this.tail + 2;
                } else {
                    if (j + 1 < end || (this.state & 4) != 0 && j + 1 == end) {
                        throw new IOException("boundary must end with CRLF");
                    }
                    if ((this.state & 4) != 0) {
                        this.len = j - this.tail;
                    }
                }
                return;
            }
            off = ++this.tail;
        }
    }
}

