/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.smarthttp.XServerProp;
import org.noear.solon.boot.smarthttp.http.FormContentFilter;
import org.noear.solon.boot.smarthttp.http.SmartHttpContextHandler;
import org.noear.solon.boot.smarthttp.websocket.WebSocketHandleImp;
import org.noear.solon.boot.smarthttp.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    HttpBootstrap _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "smart http 1.1/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        XServerProp.init();
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        long time_start = System.currentTimeMillis();
        SmartHttpContextHandler _handler = new SmartHttpContextHandler();
        this._server = new HttpBootstrap();
        this._server.configuration().bannerEnabled(false).threadNum(Runtime.getRuntime().availableProcessors() + 2);
        this._server.httpHandler((HttpServerHandler)_handler);
        if (app.enableWebSocket()) {
            this._server.webSocketHandler((WebSocketHandler)new WebSocketHandleImp());
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        }
        PrintUtil.info((Object)"Server:main: SmartHttpServer 1.1.4(smarthttp)");
        try {
            this._server.setPort(_port);
            this._server.start();
            _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
            app.signalAdd(_signal);
            app.before("**", MethodType.ALL, -9, (Handler)new FormContentFilter());
            long time_end = System.currentTimeMillis();
            String connectorInfo = "solon.connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
            if (app.enableWebSocket()) {
                PrintUtil.info((Object)(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}"));
            } else {
                PrintUtil.info((Object)(connectorInfo + "}{0.0.0.0:" + _port + "}"));
            }
            PrintUtil.info((Object)("Server:main: smarthttp: Started @" + (time_end - time_start) + "ms"));
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.shutdown();
            this._server = null;
            PrintUtil.info((Object)("Server:main: smarthttp: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

