/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.smarthttp.XServerProp;
import org.noear.solon.boot.smarthttp.http.FormContentFilter;
import org.noear.solon.boot.smarthttp.http.SmartHttpContextHandler;
import org.noear.solon.boot.smarthttp.websocket.WebSocketHandleImp;
import org.noear.solon.boot.smarthttp.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.socketd.SessionManager;
import org.smartboot.http.HttpBootstrap;
import org.smartboot.http.server.handle.Handle;

public final class XPluginImp
implements Plugin {
    HttpBootstrap _server = null;

    public static String solon_boot_ver() {
        return "smart http 1.0.21/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        XServerProp.init();
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        long time_start = System.currentTimeMillis();
        SmartHttpContextHandler _handler = new SmartHttpContextHandler();
        this._server = new HttpBootstrap();
        this._server.setBannerEnabled(false);
        this._server.pipeline().next((Handle)_handler);
        if (app.enableWebSocket()) {
            this._server.wsPipeline().next((Handle)new WebSocketHandleImp());
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        }
        System.out.println("solon.Server:main: SmartHttpServer 1.0.21(smarthttp)");
        try {
            this._server.setThreadNum(Runtime.getRuntime().availableProcessors() + 2).setPort(_port).start();
            app.signalAdd((Signal)new SignalSim(_name, _port, "http", SignalType.HTTP));
            app.before("**", MethodType.ALL, -9, (Handler)new FormContentFilter());
            long time_end = System.currentTimeMillis();
            String connectorInfo = "solon.Connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
            if (app.enableWebSocket()) {
                System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
            } else {
                System.out.println(connectorInfo + "}{0.0.0.0:" + _port + "}");
            }
            System.out.println("solon.Server:main: smarthttp: Started @" + (time_end - time_start) + "ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.shutdown();
            this._server = null;
            System.out.println("solon.Server:main: smarthttp: Has Stopped " + XPluginImp.solon_boot_ver());
        }
    }
}

