/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.server.AbstractOutputStream;
import org.smartboot.http.server.HeaderValue;
import org.smartboot.http.server.HttpRequestImpl;
import org.smartboot.http.server.HttpResponseImpl;

final class HttpOutputStream
extends AbstractOutputStream {
    private static final Map<String, byte[]>[] CACHE_CONTENT_TYPE_AND_LENGTH = new Map[512];
    private static final Map<String, byte[]> CACHE_CHUNKED_AND_LENGTH = new HashMap<String, byte[]>();
    private final OutputStream outputStream;

    public HttpOutputStream(HttpRequestImpl request, HttpResponseImpl response, OutputStream outputStream) {
        super(request, response, outputStream);
        this.outputStream = outputStream;
    }

    @Override
    protected final void writeHead() throws IOException {
        String contentType;
        if (this.committed) {
            return;
        }
        if (this.response.getHttpStatus() == null) {
            this.response.setHttpStatus(HttpStatus.OK);
        }
        if ((contentType = this.response.getContentType()) == null) {
            contentType = "text/html; charset=utf-8";
        }
        this.outputStream.write(this.getHeadPart(this.response.getHttpStatus(), contentType, this.response.getContentLength()));
        if (this.response.getHeaders() != null) {
            for (Map.Entry<String, HeaderValue> entry : this.response.getHeaders().entrySet()) {
                for (HeaderValue headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                    this.outputStream.write(this.getHeaderNameBytes(entry.getKey()));
                    this.outputStream.write(this.getBytes(headerValue.getValue()));
                }
            }
        }
        HttpOutputStream.flushDate();
        this.outputStream.write(date);
        this.committed = true;
    }

    private byte[] getHeadPart(HttpStatus httpStatus, String contentType, int contentLength) {
        this.chunked = contentLength < 0;
        byte[] data = null;
        if (httpStatus == HttpStatus.OK) {
            if (this.chunked) {
                data = CACHE_CHUNKED_AND_LENGTH.get(contentType);
            } else if (contentLength < CACHE_CONTENT_TYPE_AND_LENGTH.length) {
                data = CACHE_CONTENT_TYPE_AND_LENGTH[contentLength].get(contentType);
            }
            if (data != null) {
                return data;
            }
        }
        String str = httpStatus.getHttpStatusLine() + "\r\n" + "Content-Type" + ":" + contentType;
        if (contentLength >= 0) {
            str = str + "\r\nContent-Length:" + contentLength;
        } else if (this.chunked) {
            str = str + "\r\nTransfer-Encoding:chunked";
        }
        data = str.getBytes();
        if (httpStatus == HttpStatus.OK) {
            if (this.chunked) {
                CACHE_CHUNKED_AND_LENGTH.put(contentType, data);
            } else if (contentLength >= 0 && contentLength < CACHE_CONTENT_TYPE_AND_LENGTH.length) {
                CACHE_CONTENT_TYPE_AND_LENGTH[contentLength].put(contentType, data);
            }
        }
        return data;
    }

    static {
        for (int i = 0; i < CACHE_CONTENT_TYPE_AND_LENGTH.length; ++i) {
            HttpOutputStream.CACHE_CONTENT_TYPE_AND_LENGTH[i] = new HashMap<String, byte[]>();
        }
    }
}

