/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.AbstractResponse;
import org.smartboot.http.server.WebSocketOutputStream;
import org.smartboot.http.server.WebSocketRequestImpl;

public class WebSocketResponseImpl
extends AbstractResponse
implements WebSocketResponse {
    public WebSocketResponseImpl(WebSocketRequestImpl request, OutputStream outputStream) {
        this.init(request, new WebSocketOutputStream(request, this, outputStream));
    }

    @Override
    public void sendTextMessage(String text) {
        RunLogger.getLogger().log(Level.FINEST, "\u53d1\u9001\u5b57\u7b26\u4e32\u6d88\u606f:" + text);
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        try {
            this.send((byte)1, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBinaryMessage(byte[] bytes) {
        RunLogger.getLogger().log(Level.FINEST, "\u53d1\u9001\u4e8c\u8fdb\u5236\u6d88\u606f:" + bytes);
        try {
            this.send((byte)2, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void send(byte opCode, byte[] bytes) throws IOException {
        int length;
        int maxlength = bytes.length < 126 ? 2 + bytes.length : (bytes.length < 16384 ? 4 + bytes.length : 16388);
        byte[] writBytes = new byte[maxlength];
        for (int offset = 0; offset < bytes.length; offset += length) {
            length = bytes.length - offset;
            if (length > 16384) {
                length = 16384;
            }
            int firstByte = offset + length < bytes.length ? 0 : -128;
            firstByte = offset == 0 ? (int)((byte)(firstByte | opCode)) : (int)((byte)(firstByte | 0));
            int secondByte = length < 126 ? (int)length : 126;
            writBytes[0] = firstByte;
            writBytes[1] = secondByte;
            if (secondByte == 126) {
                writBytes[2] = (byte)(length >> 8 & 0xFF);
                writBytes[3] = (byte)(length & 0xFF);
                System.arraycopy(bytes, offset, writBytes, 4, length);
            } else {
                System.arraycopy(bytes, offset, writBytes, 2, length);
            }
            this.getOutputStream().write(writBytes, 0, length < 126 ? 2 + length : 4 + length);
        }
    }
}

