/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.server.AbstractOutputStream;
import org.smartboot.http.server.HeaderValue;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.WebSocketResponseImpl;

final class WebSocketOutputStream
extends AbstractOutputStream {
    public WebSocketOutputStream(WebSocketRequestImpl request, WebSocketResponseImpl response, OutputStream outputStream) {
        super(request, response, outputStream);
        this.chunked = false;
    }

    @Override
    protected void writeHead() throws IOException {
        String contentType;
        if (this.committed) {
            return;
        }
        if (this.response.getHttpStatus() == null) {
            this.response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
        }
        if ((contentType = this.response.getContentType()) == null) {
            contentType = "text/html; charset=utf-8";
        }
        this.outputStream.write(this.getBytes(this.response.getHttpStatus().getHttpStatusLine() + "\r\n" + "Content-Type" + ":" + contentType));
        if (this.response.getHeaders() != null) {
            for (Map.Entry<String, HeaderValue> entry : this.response.getHeaders().entrySet()) {
                for (HeaderValue headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                    this.outputStream.write(this.getHeaderNameBytes(entry.getKey()));
                    this.outputStream.write(this.getBytes(headerValue.getValue()));
                }
            }
        }
        WebSocketOutputStream.flushDate();
        this.outputStream.write(date);
        this.committed = true;
    }
}

