/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.enums.YesNoEnum;
import org.smartboot.http.server.HeaderValue;
import org.smartboot.http.server.Reset;
import org.smartboot.http.utils.CharArray;
import org.smartboot.http.utils.NumberUtils;
import org.smartboot.http.utils.StringUtils;
import org.smartboot.socket.transport.AioSession;

public final class Request
implements HttpRequest,
Reset {
    private static final Locale defaultLocale = Locale.getDefault();
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    private final AioSession aioSession;
    private final List<HeaderValue> headers = new ArrayList<HeaderValue>(8);
    private final CharArray headerValueCache = new CharArray(16384);
    private String headerTemp;
    private Map<String, String[]> parameters;
    private String uri;
    private int headerSize = 0;
    private String method;
    private String protocol;
    private String requestUri;
    private String requestUrl;
    private String contentType;
    private String queryString;
    private String scheme = "http";
    private int contentLength = -2;
    private String remoteAddr;
    private String remoteHost;
    private String hostHeader;
    private YesNoEnum websocket = null;
    private String formUrlencoded;

    Request(AioSession aioSession) {
        this.aioSession = aioSession;
    }

    public AioSession getAioSession() {
        return this.aioSession;
    }

    public final String getHost() {
        if (this.hostHeader == null) {
            this.hostHeader = this.getHeader("Host");
        }
        return this.hostHeader;
    }

    @Override
    public final String getHeader(String headName) {
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(headName)) continue;
            return headerValue.getValue();
        }
        return null;
    }

    @Override
    public final Collection<String> getHeaders(String name) {
        ArrayList<String> value = new ArrayList<String>(4);
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            value.add(headerValue.getValue());
        }
        return value;
    }

    @Override
    public final Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            nameSet.add(this.headers.get(i).getName());
        }
        return nameSet;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setHeader(int start, int length) {
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue = this.headers.get(this.headerSize);
            headerValue.setName(this.headerTemp);
            headerValue.setValue(null);
            headerValue.setValue(start, length);
        } else {
            HeaderValue headerValue = new HeaderValue(this.headerTemp, null);
            headerValue.setValue(start, length);
            headerValue.setCharArray(this.headerValueCache.getData());
            this.headers.add(headerValue);
        }
        ++this.headerSize;
    }

    public final void setHeader(String headerName, String value) {
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue = this.headers.get(this.headerSize);
            headerValue.setName(headerName);
            headerValue.setValue(value);
        } else {
            this.headers.add(new HeaderValue(headerName, value));
        }
        ++this.headerSize;
    }

    @Override
    public final String getRequestURI() {
        return this.requestUri;
    }

    public final void setRequestURI(String uri) {
        this.requestUri = uri;
    }

    @Override
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public final void setUri(String uri) {
        this.uri = uri;
    }

    public String getHeaderTemp() {
        return this.headerTemp;
    }

    public void setHeaderTemp(String headerTemp) {
        this.headerTemp = headerTemp;
    }

    @Override
    public final String getRequestURL() {
        if (this.requestUrl != null) {
            return this.requestUrl;
        }
        this.requestUrl = this.requestUri.startsWith("/") ? this.getScheme() + "://" + this.getHeader("Host") + this.getRequestURI() : this.requestUri;
        return this.requestUrl;
    }

    @Override
    public final String getScheme() {
        return this.scheme;
    }

    final void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public final String getQueryString() {
        return this.queryString;
    }

    public final void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public final String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader("Content-Type");
        return this.contentType;
    }

    @Override
    public final int getContentLength() {
        if (this.contentLength > -2) {
            return this.contentLength;
        }
        this.contentLength = NumberUtils.toInt(this.getHeader("Content-Length"), -1);
        return this.contentLength;
    }

    @Override
    public final String getParameter(String name) {
        String[] arr = name != null ? this.getParameterValues(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String[]>();
        String urlParamStr = this.queryString;
        if (StringUtils.isNotBlank(urlParamStr)) {
            urlParamStr = StringUtils.substringBefore(urlParamStr, "#");
            this.decodeParamString(urlParamStr, this.parameters);
        }
        if (this.formUrlencoded != null) {
            this.decodeParamString(this.formUrlencoded, this.parameters);
        }
        return this.getParameterValues(name);
    }

    @Override
    public final Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            this.getParameter("");
        }
        return this.parameters;
    }

    @Override
    public final String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        try {
            InetSocketAddress remote = this.aioSession.getRemoteAddress();
            InetAddress address = remote.getAddress();
            this.remoteAddr = address == null ? remote.getHostString() : address.getHostAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteAddr;
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        try {
            return this.aioSession.getRemoteAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        try {
            return this.aioSession.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        try {
            this.remoteHost = this.aioSession.getRemoteAddress().getHostString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteHost;
    }

    @Override
    public final Locale getLocale() {
        return defaultLocale;
    }

    @Override
    public final Enumeration<Locale> getLocales() {
        return Collections.enumeration(Arrays.asList(defaultLocale));
    }

    @Override
    public final String getCharacterEncoding() {
        return "utf8";
    }

    void decodeParamString(String paramStr, Map<String, String[]> paramMap) {
        String[] uriParamStrArray;
        if (StringUtils.isBlank(paramStr)) {
            return;
        }
        for (String param : uriParamStrArray = StringUtils.split(paramStr, "&")) {
            int index = param.indexOf("=");
            if (index == -1) continue;
            try {
                String key = StringUtils.substring(param, 0, index);
                String value = URLDecoder.decode(StringUtils.substring(param, index + 1), "utf8");
                String[] values = paramMap.get(key);
                if (values == null) {
                    paramMap.put(key, new String[]{value});
                    continue;
                }
                String[] newValue = new String[values.length + 1];
                System.arraycopy(values, 0, newValue, 0, values.length);
                newValue[values.length] = value;
                paramMap.put(key, newValue);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public final YesNoEnum isWebsocket() {
        return this.websocket;
    }

    public final void setWebsocket(YesNoEnum websocket) {
        this.websocket = websocket;
    }

    public String getFormUrlencoded() {
        return this.formUrlencoded;
    }

    public void setFormUrlencoded(String formUrlencoded) {
        this.formUrlencoded = formUrlencoded;
    }

    public CharArray getHeaderValueCache() {
        return this.headerValueCache;
    }

    @Override
    public void reset() {
        this.headerValueCache.setWriteIndex(0);
        this.headerSize = 0;
        this.method = null;
        this.uri = null;
        this.requestUrl = null;
        this.parameters = null;
        this.contentType = null;
        this.contentLength = -2;
        this.formUrlencoded = null;
        this.queryString = null;
    }
}

