/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.smartboot.http.server.AbstractRequest;
import org.smartboot.http.server.HttpResponseImpl;
import org.smartboot.http.server.Request;
import org.smartboot.http.utils.PostInputStream;

final class HttpRequestImpl
extends AbstractRequest {
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private InputStream inputStream;
    private final HttpResponseImpl response;

    HttpRequestImpl(Request request) {
        this.init(request);
        this.response = new HttpResponseImpl(this, (OutputStream)request.getAioSession().writeBuffer());
    }

    public final HttpResponseImpl getResponse() {
        return this.response;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int contentLength = this.getContentLength();
        this.inputStream = contentLength <= 0 || this.request.getFormUrlencoded() != null ? EMPTY_INPUT_STREAM : new PostInputStream(this.request.getAioSession().getInputStream(contentLength), contentLength);
        return this.inputStream;
    }

    @Override
    public void reset() {
        this.getRequest().reset();
        this.response.reset();
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inputStream = null;
        }
    }
}

