/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp;

import javax.net.ssl.SSLContext;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.HttpSignalProps;
import org.noear.solon.boot.smarthttp.http.FormContentFilter;
import org.noear.solon.boot.smarthttp.http.SmartHttpContextHandler;
import org.noear.solon.boot.smarthttp.websocket.WebSocketHandleImp;
import org.noear.solon.boot.smarthttp.websocket._SessionManagerImpl;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.socket.extension.plugins.SslPlugin;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    HttpBootstrap _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "smart http 1.1/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        context.beanOnloaded(ctx -> {
            try {
                this.start0(Solon.app());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        HttpSignalProps props = new HttpSignalProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        SmartHttpContextHandler _handler = new SmartHttpContextHandler();
        this._server = new HttpBootstrap();
        HttpServerConfiguration _config = this._server.configuration();
        if (Utils.isNotEmpty((String)_host)) {
            _config.host(_host);
        }
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            SSLContext sslContext = SslContextFactory.create();
            SslPlugin sslPlugin = new SslPlugin(() -> sslContext, sslEngine -> sslEngine.setUseClientMode(false));
            _config.addPlugin((org.smartboot.socket.extension.plugins.Plugin)sslPlugin);
        }
        _config.bannerEnabled(false);
        _config.readBufferSize(8192);
        _config.threadNum(Runtime.getRuntime().availableProcessors() + 2);
        if (ServerProps.request_maxHeaderSize != 0) {
            _config.readBufferSize(ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize != 0) {
            _config.setMaxFormContentSize(ServerProps.request_maxBodySize);
        }
        EventBus.push((Object)_config);
        this._server.httpHandler((HttpServerHandler)_handler);
        if (app.enableWebSocket()) {
            this._server.webSocketHandler((WebSocketHandler)new WebSocketHandleImp());
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        }
        PrintUtil.info((Object)"Server:main: SmartHttpServer 1.1(smarthttp)");
        this._server.setPort(_port);
        this._server.start();
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        app.before(-9, (Handler)new FormContentFilter());
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            PrintUtil.info((Object)(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}"));
        }
        PrintUtil.info((Object)(connectorInfo + "}{http://localhost:" + _port + "}"));
        PrintUtil.info((Object)("Server:main: smarthttp: Started @" + (time_end - time_start) + "ms"));
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.shutdown();
            this._server = null;
            PrintUtil.info((Object)("Server:main: smarthttp: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

