/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handle;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.handle.WebSocketHandle;

public class WebSocketDefaultHandle
extends WebSocketHandle {
    @Override
    public final void doHandle(WebSocketRequest request, WebSocketResponse response) throws IOException {
        block16: {
            try {
                block2 : switch (request.getWebsocketStatus()) {
                    case HandShake: {
                        this.onHandShark(request, response);
                        break;
                    }
                    case DataFrame: {
                        switch (request.getFrameOpcode()) {
                            case 1: {
                                this.handleTextMessage(request, response, new String(request.getPayload(), StandardCharsets.UTF_8));
                                break block2;
                            }
                            case 2: {
                                this.handleBinaryMessage(request, response, request.getPayload());
                                break block2;
                            }
                            case 8: {
                                try {
                                    this.onClose(request, response);
                                    break block16;
                                }
                                finally {
                                    response.close();
                                }
                            }
                            case 9: {
                                RunLogger.getLogger().log(Level.FINE, "unSupport ping now");
                                break block2;
                            }
                            case 10: {
                                RunLogger.getLogger().log(Level.FINE, "unSupport pong now");
                                break block2;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    default: {
                        throw new HttpException(HttpStatus.BAD_REQUEST);
                    }
                }
            }
            catch (Throwable throwable) {
                this.onError(throwable);
                throw throwable;
            }
        }
    }

    public void onHandShark(WebSocketRequest request, WebSocketResponse response) {
        RunLogger.getLogger().log(Level.FINE, "handShark success");
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        RunLogger.getLogger().log(Level.FINE, "close connection");
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        System.out.println(data);
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        System.out.println(data);
    }

    public void onError(Throwable throwable) {
        throwable.printStackTrace();
    }
}

