/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.enums.HttpMethodEnum;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.RequestHook;
import org.smartboot.http.server.handle.HttpHandle;
import org.smartboot.http.utils.StringUtils;

class RFC2612RequestHandle
extends HttpHandle {
    public static final int MAX_LENGTH = 261120;

    RFC2612RequestHandle() {
    }

    @Override
    public void doHandle(HttpRequest request, HttpResponse response) throws IOException {
        Request http11Request = ((RequestHook)((Object)request)).getRequest();
        this.methodCheck(http11Request);
        this.hostCheck(http11Request);
        this.uriCheck(http11Request);
        boolean keepAlive = true;
        if (request.getProtocol().endsWith("1.0") && (keepAlive = "Keep-Alive".equalsIgnoreCase(request.getHeader("Connection")))) {
            response.setHeader("Connection", "Keep-Alive");
        }
        this.doNext(request, response);
        if (!keepAlive) {
            response.close();
        }
        if (!HttpMethodEnum.GET.getMethod().equals(request.getMethod()) && request.getContentLength() > 0 && request.getInputStream().available() > 0) {
            response.close();
        }
    }

    private void methodCheck(HttpRequest request) {
        if (request.getMethod() == null) {
            throw new HttpException(HttpStatus.NOT_IMPLEMENTED);
        }
    }

    private void hostCheck(Request request) {
        if (request.getHost() == null) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }

    private void uriCheck(Request request) {
        String originalUri = request.getUri();
        if (StringUtils.length(originalUri) > 261120) {
            throw new HttpException(HttpStatus.URI_TOO_LONG);
        }
        if (originalUri.charAt(0) == '/') {
            request.setRequestURI(originalUri);
            return;
        }
        int schemeIndex = originalUri.indexOf("://");
        if (schemeIndex > 0) {
            int uriIndex = originalUri.indexOf(47, schemeIndex + 3);
            if (uriIndex == -1) {
                request.setRequestURI("/");
            } else {
                request.setRequestURI(StringUtils.substring(originalUri, uriIndex));
            }
            request.setScheme(StringUtils.substring(originalUri, 0, schemeIndex));
        } else {
            request.setRequestURI(originalUri);
        }
    }
}

