/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpHeaderDecoder;
import org.smartboot.http.utils.StringUtils;
import org.smartboot.socket.transport.AioSession;

class HttpProtocolDecoder
implements Decoder {
    private final HttpHeaderDecoder decoder = new HttpHeaderDecoder();

    HttpProtocolDecoder() {
    }

    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        int length = StringUtils.scanUntilAndTrim(byteBuffer, (byte)10, cacheChars, true);
        if (length > 0) {
            if (cacheChars[length - 1] != '\r') {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            String protocol = StringUtils.convertToString(cacheChars, 0, length - 1, StringUtils.String_CACHE_URL);
            request.setProtocol(protocol);
            return this.decoder.deocde(byteBuffer, cacheChars, aioSession, request);
        }
        return this;
    }
}

