/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.smartboot.http.logging.LogFormatter;
import org.smartboot.http.utils.Param;
import org.smartboot.http.utils.ParamReflect;

class LoggerConfig {
    private static final int MB = 0x100000;
    @Param(value="FINE")
    private Level level;
    @Param(value="true")
    private boolean log2console;
    @Param(value="utf-8")
    private String encoding;
    @Param(value="2")
    private int limit;
    @Param(value="")
    private String logDir;
    @Param(value="runlogger.log")
    private String logName;
    @Param(value="false")
    private boolean log2File;
    @Param(value="false")
    private boolean err2File;
    @Param(value="false")
    private boolean out2File;
    @Param(value="false")
    private boolean pack;

    LoggerConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            boolean bl = this.load(in);
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
        }
        return false;
    }

    public boolean load(InputStream in) {
        return ParamReflect.reflect(in, (Object)this);
    }

    public boolean isLog2File() {
        return this.log2File;
    }

    public void setLog2File(boolean log2File) {
        this.log2File = log2File;
    }

    public String getLogDir() {
        return this.logDir != null && !this.logDir.endsWith(File.separator) ? this.logDir + File.separator : this.logDir;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public boolean isPack() {
        return this.pack;
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public String getEncoding() {
        return this.encoding == null ? "utf-8" : this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getLimit() {
        return this.limit * 0x100000;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isErr2File() {
        return this.err2File;
    }

    public void setErr2File(boolean err2File) {
        this.err2File = err2File;
    }

    public boolean isOut2File() {
        return this.out2File;
    }

    public void setOut2File(boolean out2File) {
        this.out2File = out2File;
    }

    public boolean isLog2console() {
        return this.log2console;
    }

    public void setLog2console(boolean log2console) {
        this.log2console = log2console;
    }

    Handler getLogFileHandler() {
        FileHandler fh = null;
        try {
            LogFormatter sf = new LogFormatter();
            fh = new FileHandler(this.getLogDir() + this.getLogName(), this.getLimit(), 100, true);
            fh.setFormatter(sf);
            ((Handler)fh).setEncoding(this.getEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fh;
    }

    Handler getErrorFileHandler() {
        FileHandler errFh = null;
        try {
            LogFormatter sf = new LogFormatter();
            errFh = new FileHandler(this.getLogDir() + "error.log", this.getLimit(), 100, true){

                @Override
                protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                    System.setErr(new PrintStream(out, true));
                }
            };
            errFh.setFormatter(sf);
            ((Handler)errFh).setEncoding(this.getEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errFh;
    }

    Handler getOutFileHandler() {
        FileHandler outFh = null;
        try {
            LogFormatter sf = new LogFormatter();
            outFh = new FileHandler(this.getLogDir() + "out.log", this.getLimit(), 100, true){

                @Override
                protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                    System.setOut(new PrintStream(out, true));
                }
            };
            outFh.setFormatter(sf);
            ((Handler)outFh).setEncoding(this.getEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outFh;
    }

    Handler getConsoleHandler() {
        ConsoleHandler ch = new ConsoleHandler();
        ch.setFormatter(new LogFormatter());
        ch.setLevel(Level.ALL);
        try {
            ch.setEncoding(this.getEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ch;
    }
}

