/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.uploadfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.noear.solon.boot.smarthttp.uploadfile.Headers;
import org.noear.solon.boot.smarthttp.uploadfile.MultipartInputStream;
import org.noear.solon.boot.smarthttp.uploadfile.Utils;
import org.smartboot.http.HttpRequest;

public class MultipartIterator
implements Iterator<Part> {
    protected final MultipartInputStream in;
    protected boolean next;

    public MultipartIterator(HttpRequest req) throws IOException {
        Map<String, String> ct = Utils.getHeaderParams(req.getHeader("Content-Type"));
        if (!ct.containsKey("multipart/form-data")) {
            throw new IllegalArgumentException("Content-Type is not multipart/form-data");
        }
        String boundary = ct.get("boundary");
        if (boundary == null) {
            throw new IllegalArgumentException("Content-Type is missing boundary");
        }
        this.in = new MultipartInputStream(req.getInputStream(), Utils.getBytes(boundary));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next || (this.next = this.in.nextPart());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public Part next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.next = false;
        Part p = new Part();
        try {
            p.headers = Utils.readHeaders(this.in);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Map<String, String> cd = p.headers.getParams("Content-Disposition");
        p.name = cd.get("name");
        p.filename = cd.get("filename");
        p.body = this.in;
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class Part {
        public String name;
        public String filename;
        public Headers headers;
        public InputStream body;

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public InputStream getBody() {
            return this.body;
        }

        public String getString() throws IOException {
            String charset = this.headers.getParams("Content-Type").get("charset");
            return Utils.readToken(this.body, -1, charset == null ? "UTF-8" : charset, 8192);
        }
    }
}

