/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspTldLocator {
    static final Logger log = LoggerFactory.getLogger(JspTldLocator.class);

    public static Map<String, TaglibDescriptor> createTldInfos(String ... dltDirs) throws IOException {
        HashMap<String, TaglibDescriptor> tagLibInfos = new HashMap<String, TaglibDescriptor>();
        TldParser tldParser = new TldParser(true, true, true);
        for (String dltDir : dltDirs) {
            Set urls = ScanUtil.scan((ClassLoader)AppClassLoader.global(), (String)dltDir, n -> n.endsWith(".tld"));
            if (!Utils.isNotEmpty((Collection)urls)) continue;
            for (String uri : urls) {
                uri = "/" + uri;
                URL resUri = ResourceUtil.getResource((String)uri);
                TldResourcePath tldResourcePath = new TldResourcePath(resUri, uri);
                try {
                    TaglibXml taglibXml = tldParser.parse(tldResourcePath);
                    ServletContextHandler.TagLib tagLib = new ServletContextHandler.TagLib();
                    tagLib.setTaglibURI(taglibXml.getUri());
                    tagLib.setTaglibLocation(uri);
                    tagLibInfos.put(taglibXml.getUri(), (TaglibDescriptor)tagLib);
                }
                catch (Exception e) {
                    log.warn("Tdl failed to load, uri={}", (Object)uri, (Object)e);
                }
            }
        }
        return tagLibInfos;
    }
}

