/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.noear.solon.boot.jetty.websocket.CallbackImpl;
import org.noear.solon.net.websocket.WebSocketBase;

public class WebSocketImpl
extends WebSocketBase {
    private final Session real;

    public WebSocketImpl(Session real) {
        this.real = real;
        this.init(real.getUpgradeRequest().getRequestURI());
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return this.real.getRemoteAddress();
    }

    public InetSocketAddress localAddress() throws IOException {
        return this.real.getLocalAddress();
    }

    public void send(String text) {
        this.real.getRemote().sendString(text, CallbackImpl.instance);
    }

    public void send(ByteBuffer binary) {
        this.real.getRemote().sendBytes(binary, CallbackImpl.instance);
    }

    public void close() {
        super.close();
        this.real.close();
    }
}

