/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.JettyServerBase;
import org.noear.solon.boot.jetty.websocket._SessionManagerImpl;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.socketd.SessionManager;

class JettyServer
extends JettyServerBase
implements ServerLifecycle {
    protected Server _server = null;

    JettyServer() {
    }

    public void start(String host, int port) throws Throwable {
        this.setup(Solon.app(), host, port);
        this._server.start();
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app, String host, int port) throws IOException {
        Class wsClz = ClassUtil.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
        QueuedThreadPool threadPool = new QueuedThreadPool(this.props.getMaxThreads(this.props.isIoBound()), this.props.getCoreThreads());
        this._server = new Server((ThreadPool)threadPool);
        this._server.addConnector((Connector)this.getConnector(this._server, host, port, true));
        for (Integer portAdd : this.addHttpPorts) {
            this._server.addConnector((Connector)this.getConnector(this._server, host, portAdd, false));
        }
        if (Solon.app().enableSessionState()) {
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
        }
        if (app.enableWebSocket() && wsClz != null) {
            this._server.setHandler((Handler)new HandlerHub(this.buildHandler()));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            this._server.setHandler(this.buildHandler());
        }
        EventBus.publish((Object)this._server);
    }

    protected Handler buildHandler() throws IOException {
        if (ClassUtil.hasClass(() -> ServletContextHandler.class)) {
            return this.getServletHandler();
        }
        return this.getJettyHandler();
    }
}

