/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.PluginJetty;
import org.noear.solon.boot.jetty.PluginJettyJsp;
import org.noear.solon.boot.jetty.http.FormContentFilter;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.PrintUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private PluginJetty _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jetty 9.4/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        if (!Solon.global().enableHttp()) {
            return;
        }
        if (ServerProps.request_maxBodySize != 0) {
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", String.valueOf(ServerProps.request_maxBodySize));
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        context.beanOnloaded(ctx -> this.start0(Solon.global(), context));
    }

    private void start0(SolonApp app, AopContext context) {
        Class jspClz = Utils.loadClass((String)"org.eclipse.jetty.jsp.JettyJspServlet");
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        String _host = app.cfg().get("server.http.host", null);
        if (_port < 1) {
            _port = app.port();
        }
        if (Utils.isEmpty((String)_host)) {
            _host = app.cfg().serverHost();
        }
        this._server = jspClz == null ? new PluginJetty(_port, _host) : new PluginJettyJsp(_port, _host);
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: Jetty 9.4(jetty)");
        this._server.start(context);
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: jetty: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        System.out.println(connectorInfo + "}{http://localhost:" + _port + "}");
        PrintUtil.info((Object)("Server:main: jetty: Started @" + (time_end - time_start) + "ms"));
        app.before(-9, (Handler)new FormContentFilter());
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("Server:main: jetty: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

