/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.PluginJettyBase;
import org.noear.solon.boot.jetty.websocket._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.socketd.SessionManager;

class PluginJetty
extends PluginJettyBase
implements Plugin {
    protected Server _server = null;
    private int port;
    private String host;

    public PluginJetty(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public void start(AopContext context) {
        try {
            this.setup(Solon.global(), context);
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app, AopContext context) throws IOException {
        Class wsClz = Utils.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
        this._server = new Server();
        ServerConnector connector = this.getConnector(this._server);
        connector.setPort(this.port);
        if (Utils.isNotEmpty((String)this.host)) {
            connector.setHost(this.host);
        }
        this._server.addConnector((Connector)connector);
        if (Solon.global().enableSessionState()) {
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
        }
        if (app.enableWebSocket() && wsClz != null) {
            this._server.setHandler((Handler)new HandlerHub(this.buildHandler()));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            this._server.setHandler(this.buildHandler());
        }
        EventBus.push((Object)this._server);
    }

    protected Handler buildHandler() throws IOException {
        if (Utils.loadClass((String)"org.eclipse.jetty.servlet.ServletContextHandler") == null) {
            return this.getJettyHandler();
        }
        return this.getServletHandler();
    }
}

