/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.BiConsumer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.noear.solon.Solon;
import org.noear.solon.boot.jetty.PluginJetty;
import org.noear.solon.boot.jetty.http.JtJspStarter;
import org.noear.solon.core.Props;

class PluginJettyJsp
extends PluginJetty {
    public PluginJettyJsp(int port) {
        super(port);
    }

    @Override
    protected Handler buildHandler() throws IOException {
        ServletContextHandler handler = this.getServletHandler();
        this.enableJspSupport(handler);
        return handler;
    }

    private void enableJspSupport(ServletContextHandler handler) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon.boot.jetty.jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        handler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JtJspStarter(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        Props properties = Solon.cfg().getProp("solon.jetty.jsp");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> holderJsp.setInitParameter((String)k, (String)v)));
        handler.addServlet(holderJsp, "*.jsp");
    }
}

