/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.jetty.PluginJetty;
import org.noear.solon.boot.jetty.PluginJettyJsp;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.boot.jetty.http.XFormContentFilter;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.PrintUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private PluginJetty _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jetty 9.4/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        Aop.context().beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        XServerProp.init();
        Aop.beanOnloaded(() -> this.start0(app));
    }

    private void start0(SolonApp app) {
        Class jspClz = Utils.loadClass((String)"org.eclipse.jetty.jsp.JettyJspServlet");
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        this._server = jspClz == null ? new PluginJetty(_port) : new PluginJettyJsp(_port);
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: Jetty 9.4(jetty)");
        this._server.start(app);
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: jetty: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        } else {
            System.out.println(connectorInfo + "}{0.0.0.0:" + _port + "}");
        }
        PrintUtil.info((Object)("Server:main: jetty: Started @" + (time_end - time_start) + "ms"));
        app.before("**", (Handler)new XFormContentFilter());
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("Server:main: jetty: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

