/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.noear.solon.Solon;
import org.noear.solon.boot.jetty.websocket._SocketServerSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ListenerProxy;
import org.noear.solon.socketd.ProtocolManager;

public class WebSocketListenerImp
extends WebSocketAdapter {
    public void onWebSocketConnect(org.eclipse.jetty.websocket.api.Session sess) {
        super.onWebSocketConnect(sess);
        Session session = _SocketServerSession.get(this.getSession());
        sess.getUpgradeRequest().getHeaders().forEach((k, v) -> {
            if (v.size() > 0) {
                session.headerSet(k, (String)v.get(0));
            }
        });
        ListenerProxy.getGlobal().onOpen(session);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(payload, offset, len);
            Session session = _SocketServerSession.get(this.getSession());
            Message message = null;
            message = Solon.global().enableWebSocketD() ? ProtocolManager.decode((ByteBuffer)buf) : Message.wrap((String)this.getSession().getUpgradeRequest().getOrigin(), null, (byte[])buf.array());
            ListenerProxy.getGlobal().onMessage(session, message);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onWebSocketText(String text) {
        try {
            Session session = _SocketServerSession.get(this.getSession());
            Message message = Message.wrap((String)this.getSession().getUpgradeRequest().getRequestURI().toString(), null, (String)text);
            ListenerProxy.getGlobal().onMessage(session, message.isString(true));
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        ListenerProxy.getGlobal().onClose(_SocketServerSession.get(this.getSession()));
        _SocketServerSession.remove(this.getSession());
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable cause) {
        ListenerProxy.getGlobal().onError(_SocketServerSession.get(this.getSession()), cause);
    }
}

