/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.MessageUtils;
import org.noear.solon.extend.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static Map<org.eclipse.jetty.websocket.api.Session, Session> sessions = new HashMap<org.eclipse.jetty.websocket.api.Session, Session>();
    org.eclipse.jetty.websocket.api.Session real;
    private String _sessionId = Utils.guid();
    private String _path;
    private boolean _open = true;
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(org.eclipse.jetty.websocket.api.Session real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            org.eclipse.jetty.websocket.api.Session session = real;
            synchronized (session) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(org.eclipse.jetty.websocket.api.Session real) {
        sessions.remove(real);
    }

    public _SocketServerSession(org.eclipse.jetty.websocket.api.Session real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        return this.real.getUpgradeRequest().getRequestURI();
    }

    public String path() {
        if (this._path == null) {
            this._path = this.real.getUpgradeRequest().getRequestURI().getPath();
        }
        return this._path;
    }

    public void send(String message) {
        try {
            if (Solon.global().enableWebSocketD()) {
                this.sendBytes(MessageUtils.encode((Message)MessageUtils.wrap((byte[])message.getBytes(StandardCharsets.UTF_8))));
            } else {
                this.real.getRemote().sendString(message);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(byte[] message) {
        if (Solon.global().enableWebSocketD()) {
            this.sendBytes(MessageUtils.encode((Message)MessageUtils.wrap((byte[])message)));
        } else {
            this.sendBytes(ByteBuffer.wrap(message));
        }
    }

    public void send(Message message) {
        super.send(message);
        if (Solon.global().enableWebSocketD()) {
            this.sendBytes(MessageUtils.encode((Message)message));
        } else {
            this.sendBytes(ByteBuffer.wrap(message.body()));
        }
    }

    private void sendBytes(ByteBuffer buf) {
        try {
            this.real.getRemote().sendBytes(buf);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() throws IOException {
        this._open = false;
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return this._open && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getLocalAddress();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

