/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.noear.solon.boot.jetty.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;

public class WebSocketListenerImp
extends WebSocketAdapter {
    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        XListenerProxy.getGlobal().onOpen(_SocketSession.get(this.getSession()));
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(payload, offset, len);
            XSession session = _SocketSession.get(this.getSession());
            XMessage message = XMessage.wrap((String)this.getSession().getUpgradeRequest().getOrigin(), (byte[])buf.array());
            XListenerProxy.getGlobal().onMessage(session, message, false);
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onWebSocketText(String text) {
        try {
            XSession session = _SocketSession.get(this.getSession());
            XMessage message = XMessage.wrap((String)this.getSession().getUpgradeRequest().getRequestURI().toString(), (byte[])text.getBytes("UTF-8"));
            XListenerProxy.getGlobal().onMessage(session, message, true);
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        XListenerProxy.getGlobal().onClose(_SocketSession.get(this.getSession()));
        _SocketSession.remove(this.getSession());
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable cause) {
        XListenerProxy.getGlobal().onError(_SocketSession.get(this.getSession()), cause);
    }
}

