/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.http;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.holder.FilterHodler;
import org.noear.solon.boot.jetty.holder.ServletHolder;
import org.noear.solon.core.Aop;

public class JtContainerInitializerProxy
extends AbstractLifeCycle.AbstractLifeCycleListener {
    ServletContext sc;
    Set<ServletContainerInitializer> initializers = new LinkedHashSet<ServletContainerInitializer>();
    Set<FilterHodler> filters = new LinkedHashSet<FilterHodler>();
    Set<EventListener> listeners = new LinkedHashSet<EventListener>();
    Set<ServletHolder> servlets = new LinkedHashSet<ServletHolder>();

    public JtContainerInitializerProxy(ServletContext servletContext) {
        this.sc = servletContext;
        Aop.beanForeach(bw -> {
            WebFilter anno;
            if (bw.raw() instanceof ServletContainerInitializer) {
                this.initializers.add((ServletContainerInitializer)bw.raw());
            }
            if (bw.raw() instanceof Filter && (anno = bw.clz().getAnnotation(WebFilter.class)) != null) {
                this.filters.add(new FilterHodler(anno, (Filter)bw.raw()));
            }
            if (bw.raw() instanceof EventListener && (anno = bw.clz().getAnnotation(WebListener.class)) != null) {
                this.listeners.add((EventListener)bw.raw());
            }
            if (bw.raw() instanceof Servlet && (anno = bw.clz().getAnnotation(WebServlet.class)) != null) {
                this.servlets.add(new ServletHolder((WebServlet)anno, (Servlet)bw.raw()));
            }
        });
    }

    public void lifeCycleStarting(LifeCycle event) {
        try {
            this.onStartup(new HashSet(), this.sc);
        }
        catch (Exception ex) {
            throw XUtil.throwableWrap((Throwable)ex);
        }
    }

    public void onStartup(Set<Class<?>> set, ServletContext sc) throws ServletException {
        FilterRegistration.Dynamic dy;
        for (ServletContainerInitializer si : this.initializers) {
            si.onStartup(set, sc);
        }
        for (EventListener l : this.listeners) {
            sc.addListener(l);
        }
        for (FilterHodler f : this.filters) {
            dy = sc.addFilter(f.anno.filterName(), f.filter);
            dy.addMappingForUrlPatterns(EnumSet.copyOf(Arrays.asList(f.anno.dispatcherTypes())), false, f.anno.urlPatterns());
        }
        for (ServletHolder s : this.servlets) {
            dy = sc.addServlet(s.anno.name(), s.servlet);
            dy.setLoadOnStartup(s.anno.loadOnStartup());
            dy.addMapping(s.anno.urlPatterns());
        }
    }
}

