/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.noear.solon.boot.jetty.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;
import org.noear.solon.extend.xsocket.XSocketContextHandler;

public class WebSocketListenerImp
extends WebSocketAdapter {
    static XSocketContextHandler handler = new XSocketContextHandler(XMethod.WEBSOCKET);
    static XListener listener = XListenerProxy.getGlobal();

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        listener.onOpen(_SocketSession.get(this.getSession()));
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(payload, offset, len);
            XSession session = _SocketSession.get(this.getSession());
            XMessage message = XMessage.wrap((String)this.getSession().getUpgradeRequest().getOrigin(), (byte[])buf.array());
            listener.onMessage(session, message);
            if (!message.getHandled()) {
                handler.handle(session, message, false);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onWebSocketText(String text) {
        try {
            XSession session = _SocketSession.get(this.getSession());
            XMessage message = XMessage.wrap((String)this.getSession().getUpgradeRequest().getRequestURI().toString(), (byte[])text.getBytes("UTF-8"));
            listener.onMessage(session, message);
            if (!message.getHandled()) {
                handler.handle(session, message, true);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        listener.onClose(_SocketSession.get(this.getSession()));
        _SocketSession.remove(this.getSession());
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable cause) {
        listener.onError(_SocketSession.get(this.getSession()), cause);
    }
}

