/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.MultipartUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XSessionState;

public class JtHttpContext
extends XContext {
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    protected Map<String, List<XFile>> _fileMap;
    private String _ip;
    private URI _uri;
    private XMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private XMap _cookieMap;
    private XMap _headerMap;

    public JtHttpContext(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
        if (this.sessionState().replaceable()) {
            this.sessionStateInit(new XSessionState(){

                public String sessionId() {
                    return JtHttpContext.this._request.getRequestedSessionId();
                }

                public Object sessionGet(String key) {
                    return JtHttpContext.this._request.getSession().getAttribute(key);
                }

                public void sessionSet(String key, Object val) {
                    JtHttpContext.this._request.getSession().setAttribute(key, val);
                }
            });
        }
        if (this.isMultipart()) {
            try {
                this._fileMap = new HashMap<String, List<XFile>>();
                MultipartUtil.buildParamsAndFiles(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._request.getRemoteAddr();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return this._request.getRequestURL().toString();
    }

    public long contentLength() {
        return this._request.getContentLength();
    }

    public String contentType() {
        return this._request.getContentType();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public String[] paramValues(String key) {
        return this._request.getParameterValues(key);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public String param(String key, String def) {
        String temp = (String)this.paramMap().get((Object)key);
        if (XUtil.isEmpty((String)temp)) {
            return def;
        }
        return temp;
    }

    public XMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new XMap();
            Enumeration names = this._request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = this._request.getParameter(name);
                this._paramMap.put(name, (Object)value);
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            this._request.getParameterMap().forEach((k, v) -> this._paramsMap.put((String)k, Arrays.asList(v)));
        }
        return this._paramsMap;
    }

    public List<XFile> files(String key) throws Exception {
        if (this.isMultipartFormData()) {
            List<XFile> temp = this._fileMap.get(key);
            if (temp == null) {
                return new ArrayList<XFile>();
            }
            return temp;
        }
        return new ArrayList<XFile>();
    }

    public XMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new XMap();
            Cookie[] _cookies = this._request.getCookies();
            if (_cookies != null) {
                for (Cookie c : _cookies) {
                    this._cookieMap.put(c.getName(), (Object)c.getValue());
                }
            }
        }
        return this._cookieMap;
    }

    public XMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new XMap();
            Enumeration headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                String value = this._request.getHeader(key);
                this._headerMap.put(key, (Object)value);
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
    }

    protected void contentTypeDoSet(String contentType) {
        this._response.setContentType(contentType);
    }

    public OutputStream outputStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void output(String str) {
        try {
            PrintWriter writer = this._response.getWriter();
            writer.write(str);
            writer.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            ServletOutputStream out = this._response.getOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                out.write(buff, 0, rc);
            }
            out.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        Cookie c = new Cookie(key, val);
        if (XUtil.isNotEmpty((String)path)) {
            c.setPath(path);
        }
        c.setMaxAge(maxAge);
        if (XUtil.isNotEmpty((String)domain)) {
            c.setDomain(domain);
        }
        this._response.addCookie(c);
    }

    public void redirect(String url) {
        try {
            this._response.sendRedirect(url);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void redirect(String url, int code) {
        this.statusSet(code);
        this._response.setHeader("Location", url);
    }

    public int status() {
        return this._response.getStatus();
    }

    public void statusSet(int status) {
        this._response.setStatus(status);
    }
}

