/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.boot.jetty.JtHttpContextHandler;
import org.noear.solon.core.XPlugin;

final class XPluginJetty
implements XPlugin {
    private Server _server = null;

    XPluginJetty() {
    }

    public void start(XApp app) {
        XProperties props = app.prop();
        int s_timeout = props.getInt("server.session.timeout", 0);
        SessionHandler s_handler = new SessionHandler();
        if (s_timeout > 0) {
            s_handler.setMaxInactiveInterval(s_timeout);
        }
        JtHttpContextHandler _handler = new JtHttpContextHandler(true, app);
        s_handler.setHandler(_handler);
        this._server = new Server(app.port());
        this._server.setSessionIdManager(new DefaultSessionIdManager(this._server));
        this._server.setHandler(s_handler);
        if (props != null) {
            props.forEach((k, v) -> {
                String key = k.toString();
                if (key.indexOf(".jetty.") > 0) {
                    this._server.setAttribute(key, v);
                }
            });
        }
        try {
            this._server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        app.onStop(this::stop);
    }

    public void stop() {
        try {
            this._server.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

