/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.http.HttpServerConfigure;
import org.noear.solon.boot.jdkhttp.JdkHttpServer;
import org.noear.solon.core.handle.Handler;

public class JdkHttpServerComb
implements HttpServerConfigure,
ServerLifecycle {
    private Executor executor;
    private Handler handler;
    private boolean enableSsl = true;
    private Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    private List<JdkHttpServer> servers = new ArrayList<JdkHttpServer>();

    public void enableSsl(boolean enable) {
        this.enableSsl = enable;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public boolean isSecure() {
        if (this.servers.size() > 0) {
            return this.servers.get(0).isSecure();
        }
        return false;
    }

    public void start(String host, int port) throws Throwable {
        JdkHttpServer s1 = new JdkHttpServer();
        s1.setExecutor(this.executor);
        s1.setHandler(this.handler);
        s1.enableSsl(this.enableSsl);
        s1.start(host, port);
        this.servers.add(s1);
        for (Integer portAdd : this.addHttpPorts) {
            JdkHttpServer s2 = new JdkHttpServer();
            s2.setExecutor(this.executor);
            s2.setHandler(this.handler);
            s2.enableSsl(false);
            s2.start(host, portAdd);
            this.servers.add(s2);
        }
    }

    public void stop() throws Throwable {
        for (ServerLifecycle serverLifecycle : this.servers) {
            serverLifecycle.stop();
        }
    }
}

