/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jdkhttp.JdkHttpContext;
import org.noear.solon.boot.jdkhttp.XPluginImp;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class JdkHttpContextHandler
implements HttpHandler {
    private final Handler handler;

    public JdkHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void handle(HttpExchange exchange) {
        try {
            this.handleDo(exchange);
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
        finally {
            exchange.close();
        }
    }

    protected void handleDo(HttpExchange exchange) throws IOException {
        JdkHttpContext ctx = new JdkHttpContext(exchange);
        try {
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
            }
            this.handler.handle((Context)ctx);
            if (ctx.getHandled() || ctx.status() >= 200) {
                ctx.commit();
            } else {
                ctx.status(404);
                ctx.commit();
            }
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            exchange.sendResponseHeaders(500, -1L);
        }
    }
}

